class GeneralSettingsResponseModel {
  String? remark;
  String? status;
  Data? data;

  GeneralSettingsResponseModel({
    this.remark,
    this.status,
    this.data,
  });

  factory GeneralSettingsResponseModel.fromJson(Map<String, dynamic> json) {
    return GeneralSettingsResponseModel(
      remark: json['remark']?.toString(),
      status: json['status']?.toString(),
      data: json['data'] != null ? Data.fromJson(json['data']) : null,
    );
  }

  Map<String, dynamic> toJson() => {
        'remark': remark,
        'status': status,
        'data': data?.toJson(),
      };
}

class Data {
  GeneralSetting? generalSetting;
  String? timeZone;
  String? socialLoginRedirect;
  String? googleLogin;
  String? facebookLogin;
  String? linkedinLogin;

  Data({
    this.generalSetting,
    this.timeZone,
    this.socialLoginRedirect,
    this.googleLogin,
    this.facebookLogin,
    this.linkedinLogin,
  });

  factory Data.fromJson(Map<String, dynamic> json) {
    return Data(
      generalSetting: json['general_setting'] != null ? GeneralSetting.fromJson(json['general_setting']) : null,
      timeZone: json['timezone']?.toString(),
      socialLoginRedirect: json['social_login_redirect']?.toString(),
      googleLogin: json['google_login']?.toString(),
      facebookLogin: json['facebook_login']?.toString(),
      linkedinLogin: json['linkedin_login']?.toString(),
    );
  }

  Map<String, dynamic> toJson() => {
        'general_setting': generalSetting?.toJson(),
        'timezone': timeZone,
        'social_login_redirect': socialLoginRedirect,
        'google_login': googleLogin,
        'facebook_login': facebookLogin,
        'linkedin_login': linkedinLogin,
      };
}

class GeneralSetting {
  String? id;
  String? siteName;
  String? curText;
  String? curSym;
  String? emailFrom;
  String? smsBody;
  String? smsFrom;
  String? baseColor;
  String? secondaryColor;
  String? server;
  String? kv;
  String? ev;
  String? en;
  String? sv;
  String? sn;
  String? forceSsl;
  String? maintenanceMode;
  String? securePassword;
  String? agree;
  String? registration;
  String? activeTemplate;
  String? lastCron;
  SocialiteCredentials? socialiteCredentials;
  PusherConfig? pusherConfig;
  String? pn;
  String? skipTime;
  String? tmdbApi;
  String? multiLanguage;
  String? videoAdSubscriptionUser;
  String? adShowMobile;
  String? deviceLimit;
  String? createdAt;
  String? updatedAt;
  String? appPurchase;
  //
  String? watchParty;
  String? liveTv;
  String? tournament;
  String? requestItem;
  String? geneRe;

  GeneralSetting({
    this.id,
    this.siteName,
    this.curText,
    this.curSym,
    this.emailFrom,
    this.smsBody,
    this.smsFrom,
    this.baseColor,
    this.secondaryColor,
    this.server,
    this.kv,
    this.ev,
    this.en,
    this.sv,
    this.sn,
    this.forceSsl,
    this.maintenanceMode,
    this.securePassword,
    this.agree,
    this.registration,
    this.activeTemplate,
    this.lastCron,
    this.socialiteCredentials,
    this.pusherConfig,
    this.pn,
    this.skipTime,
    this.tmdbApi,
    this.multiLanguage,
    this.videoAdSubscriptionUser,
    this.adShowMobile,
    this.deviceLimit,
    this.createdAt,
    this.updatedAt,
    this.appPurchase,
    //
    this.watchParty,
    this.liveTv,
    this.tournament,
    this.requestItem,
    this.geneRe,
  });

  factory GeneralSetting.fromJson(Map<String, dynamic> json) {
    return GeneralSetting(
      id: json['id']?.toString(),
      siteName: json['site_name']?.toString(),
      curText: json['cur_text']?.toString(),
      curSym: json['cur_sym']?.toString(),
      emailFrom: json['email_from']?.toString(),
      smsBody: json['sms_body']?.toString(),
      smsFrom: json['sms_from']?.toString(),
      baseColor: json['base_color']?.toString(),
      secondaryColor: json['secondary_color']?.toString(),
      server: json['server']?.toString(),
      kv: json['kv']?.toString(),
      ev: json['ev']?.toString(),
      en: json['en']?.toString(),
      sv: json['sv']?.toString(),
      sn: json['sn']?.toString(),
      forceSsl: json['force_ssl']?.toString(),
      maintenanceMode: json['maintenance_mode']?.toString(),
      securePassword: json['secure_password']?.toString(),
      agree: json['agree']?.toString(),
      registration: json['registration']?.toString(),
      activeTemplate: json['active_template']?.toString(),
      lastCron: json['last_cron']?.toString(),
      socialiteCredentials: json['socialite_credentials'] != null ? SocialiteCredentials.fromJson(json['socialite_credentials']) : null,
      pusherConfig: json['pusher_config'] != null ? PusherConfig.fromJson(json['pusher_config']) : null,
      pn: json['pn']?.toString(),
      skipTime: json['skip_time']?.toString(),
      tmdbApi: json['tmdb_api']?.toString(),
      multiLanguage: json['multi_language']?.toString(),
      videoAdSubscriptionUser: json['video_ad_subscription_user']?.toString(),
      adShowMobile: json['ad_show_mobile']?.toString(),
      deviceLimit: json['device_limit']?.toString(),
      createdAt: json['created_at']?.toString(),
      updatedAt: json['updated_at']?.toString(),
      appPurchase: json['in_app_payment']?.toString(),
      //
      watchParty: json['watch_party']?.toString(),
      liveTv: json['live_tv']?.toString(),
      tournament: json['tournament']?.toString(),
      requestItem: json['request_item']?.toString(),
      geneRe: json['genre']?.toString(),
    );
  }

  Map<String, dynamic> toJson() => {
        'id': id,
        'site_name': siteName,
        'cur_text': curText,
        'cur_sym': curSym,
        'email_from': emailFrom,
        'sms_body': smsBody,
        'sms_from': smsFrom,
        'base_color': baseColor,
        'secondary_color': secondaryColor,
        'server': server,
        'kv': kv,
        'ev': ev,
        'en': en,
        'sv': sv,
        'sn': sn,
        'force_ssl': forceSsl,
        'maintenance_mode': maintenanceMode,
        'secure_password': securePassword,
        'agree': agree,
        'registration': registration,
        'active_template': activeTemplate,
        'last_cron': lastCron,
        'socialite_credentials': socialiteCredentials?.toJson(),
        'pusher_config': pusherConfig?.toJson(),
        'pn': pn,
        'skip_time': skipTime,
        'tmdb_api': tmdbApi,
        'multi_language': multiLanguage,
        'video_ad_subscription_user': videoAdSubscriptionUser,
        'ad_show_mobile': adShowMobile,
        'device_limit': deviceLimit,
        'created_at': createdAt,
        'updated_at': updatedAt,
        'in_app_payment': appPurchase,
        //
        'watch_party': watchParty,
        'live_tv': liveTv,
        'tournament': tournament,
        'request_item': requestItem,
        'genre': geneRe,
      };
}

class SocialiteCredentials {
  Credential? google;
  Credential? facebook;
  Credential? linkedin;

  SocialiteCredentials({this.google, this.facebook, this.linkedin});

  factory SocialiteCredentials.fromJson(Map<String, dynamic> json) {
    return SocialiteCredentials(
      google: json['google'] != null ? Credential.fromJson(json['google']) : null,
      facebook: json['facebook'] != null ? Credential.fromJson(json['facebook']) : null,
      linkedin: json['linkedin'] != null ? Credential.fromJson(json['linkedin']) : null,
    );
  }

  Map<String, dynamic> toJson() => {
        'google': google?.toJson(),
        'facebook': facebook?.toJson(),
        'linkedin': linkedin?.toJson(),
      };
}

class Credential {
  String? clientId;
  String? clientSecret;
  String? status;

  Credential({this.clientId, this.clientSecret, this.status});

  factory Credential.fromJson(Map<String, dynamic> json) => Credential(
        clientId: json['client_id']?.toString(),
        clientSecret: json['client_secret']?.toString(),
        status: json['status']?.toString(),
      );

  Map<String, dynamic> toJson() => {
        'client_id': clientId,
        'client_secret': clientSecret,
        'status': status,
      };
}

class PusherConfig {
  String? appId;
  String? appKey;
  String? appSecretKey;
  String? cluster;

  PusherConfig({this.appId, this.appKey, this.appSecretKey, this.cluster});

  factory PusherConfig.fromJson(Map<String, dynamic> json) => PusherConfig(
        appId: json['app_id']?.toString(),
        appKey: json['app_key']?.toString(),
        appSecretKey: json['app_secret_key']?.toString(),
        cluster: json['cluster']?.toString(),
      );

  Map<String, dynamic> toJson() => {
        'app_id': appId,
        'app_key': appKey,
        'app_secret_key': appSecretKey,
        'cluster': cluster,
      };
}
